#!/usr/bin/python3
"""
With this line (it must be the first one) the program can be started as cronjob
with path/filename, provided the program has been given the "executable"
property either in the file manager or in the terminal with chmod +x path/filename.

cronclock.py sends a string, which can be understood by Serial Input of
Arduino library mtrtos. Number one has time format hhmmss and number two
has date format yyMMdd
mtrtos application must get this information to syncronize library base clock

"""
#run as cronjob every minute
import sys
import serial
import time 

port = '/dev/ttyUSB0'
try:
    ser = serial.Serial( port, baudrate=38400, timeout=0.050)   #timeout 50 ms
except (FileNotFoundError, serial.serialutil.SerialException) :
    sys.exit (0)

ti =  time.localtime()

h = str(ti.tm_hour)
if len (h) < 2 :
    h="0"+ h
m = str(ti.tm_min)
if len (m) < 2 :
    m ="0"+ m
s = str(ti.tm_sec)
if len (s) < 2 :
    s ="0"+ s
    
y = str(ti.tm_year % 100)
mon = str(ti.tm_mon)
if len (mon) < 2 :
    mon ="0"+ mon
d = str(ti.tm_mday)
if len (d) < 2 :
    d ="0"+ d
pktstr = "clock " + h + m + s +" "+ y + mon + d +"\n"
ser.write  (bytes(pktstr, 'UTF-8' ) )
time.sleep(0.010)
sinp  = ser.read(1)      #receive and abort possible response
while len(sinp) > 0:    
    sinp  = ser.read(1)
ser.close()
sys.exit (0)


