#!/usr/bin/python3
"""
With this line (it must be the first one) the program can be started in the
terminal with path/filename, provided the program has been given the "executable"
property either in the file manager or in the terminal with chmod +x path/filename.

mtcomm.py works like Arduino Serial Monitor. It should run on Raspberry Pi.
Program flow: Wait for user input, open serial port, send user input,
wait for response, print response, close serial port, wait for user input and so on.
In this way cronjobs can use serial port almost all the time.
"""
import serial
import sys

myinp = ''
port = '/dev/ttyUSB0'

print()
print('mtcomm.py    ' + port + '    38400 Baud')
print('LF (Enter) -> menu,   exit -> end of program')
while 1 :                   #main loop
    myinp = input('')
    if myinp == 'exit' :
        break
    try:
        ser = serial.Serial( port, baudrate=38400, timeout=0.005)
    except (FileNotFoundError, serial.serialutil.SerialException) :
        print ("Serial Port not available")
        sys.exit (0)
    ser.write (bytes( myinp +"\n", 'UTF-8'))

    n = 400         #receive response, which may be fragmented and delayed
    line = ''               
    while n > 0:           
        sinp  = ser.read(1)      #timeout 5 ms      
        if len(sinp):
            if chr ( sinp[0] ) == "\n" :   #line received completely
                print (line)            
                line = ''
            else:
                line += chr ( sinp[0] )    #make line
        n = n - 1
    ser.close()                
print ("bye")
sys.exit (0)             



