#ifdef ELEM10

//A symmetric flashing LED is basic function of task LPUSH
//In addition: when LBUTTON is pressed less than 300 ms after LED is turned on, LED (colour) is changed
//That means: pin event of LBUTTON is combined with timeout
//In the same way semaphore event can be combined with timeout

Tnum bl (BLUE, 800);

////////Task LPUSH    
void lpush1 () {         
  WPIN (bl.OA, HIGH) ;  
  os.mtpin (LBUTTON, LOW, lpush2);  //wait for pushbutton is pressed
  os.mtdelay (300, lpush3);         //timeout (push of button not in time);
}
void lpush2 () {            //push of button in time, change LED (colour)
  if (bl.OA == BLUE) { 
    bl.OA = GREEN;
    WPIN (BLUE, LOW);
  }
  else {
    bl.OA = BLUE;  
    WPIN (GREEN, LOW);
  }
  os.mtdelay (bl.OB, lpush1);
}
void lpush3 () {            //push of button not in time, continue flashing with same LED
  os.mtdelay (bl.OB - 300, lpush4);     
}
void lpush4 () {          
  WPIN (bl.OA, LOW) ; 
  os.mtdelay (bl.OB,lpush1);        
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits   
  os.start (LPUSH, lpush1);
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}

#endif  