#ifdef ELEM12

//Task CALC has no events and causes max. CPU load (idle = 0), like a 
//task, which performs long time calculations. Because task CALC
//is cooperative by splitting the calculation into parts < 1 ms and 
//using os.mtcoop, task TBLUE retains its real time capability

/////////////Task TBLUE     "Higher frequency" flashing
void tblue1() {
  WPIN(BLUE, !RPIN(BLUE));
  os.mtdelay ( 20 , tblue1);   //try 1 and check with DSO
}

#define CALC LPUSH       //Task LPUSH is now task CALC

Tnum ca (0, 0);

////////Task CALC 
void calc1() {    
  delayMicroseconds (900);   //simulates part one of a calculation
  ca.OA++;          
  os.mtcoop(calc2);
}
void calc2() {  
  delayMicroseconds (800);   //simulates part two of a calculation         
  os.mtcoop(calc3);
}
void calc3() {   
  delayMicroseconds (950);   //simulates part three of a calculation        
  os.mtcoop ( calc1);
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1() {        //to add own and other inits
  os.start(CALC, calc1);
  os.start(TBLUE, tblue1);
  os.mtcoop(gpcycle2);
}

void gpcycle2() {                         //Task function as endless loop
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));  //toggled LED as sign of life
  PR (ca.OA);        //counter shows that task CALC is working
  PR (" "); 
  PRln (os.idle);    //always zero  (max. CPU load)
  os.mtdelay(2000, gpcycle2);  
}

#endif
