#ifdef ELEM2

//Three endless tasks with different LED flashing modes
//can be deactivated or activated by pushbutton using a global flag.

Tnum fl (1,0);     //Tnum object to provide common task data nb[0] and nb[1]
                   //Note: short alternatives  OA and OB
                   
#define FLAG  fl.nb[0]    //special short alternative

//////////////////Task TYELLOW     symmetric flashing
void tyellow1 () {
  if (FLAG) 
    WPIN(YELLOW , !RPIN( YELLOW ) ); 
  else WPIN(YELLOW , HIGH);  
  os.mtdelay (100, tyellow1); 
}
//////////////////Task TGREEN      asymmetric flashing
void tgreen1 () {
  WPIN(GREEN, HIGH);  
  os.mtdelay (100, tgreen2); 
}
void tgreen2 () {
  if (FLAG) WPIN(GREEN, LOW) ;  
  os.mtdelay (1000, tgreen1); 
}
///////////////////Task TBLUE    "Higher frequency" flashing 
void tblue1 () {
  if (FLAG) 
    WPIN(BLUE , !RPIN(BLUE) ); 
  else WPIN(BLUE, HIGH);  
  os.mtdelay (25, tblue1); 
}

///////////Task LPUSH     detect push of button and toggle FLAG
void lpush1 () {                
  os.mtpin (LBUTTON, LOW, lpush2);   //wait for pushbutton is pressed
}
void lpush2 () {          
  FLAG = !FLAG;
  os.mtcoop (lpush1);        
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits    
  os.start (TYELLOW, tyellow1);
  os.start (TGREEN, tgreen1);  
  os.start (TBLUE, tblue1);
  os.start (LPUSH, lpush1);            
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}
#endif  