#ifdef ELEM3
//Two flashing LED can be deactivated/activated by a pushbutton each, using different 
//methods: start/stop and semaphore

//////////////////Task TYELLOW      symmetric flashing
void tyellow1 () {
  WPIN(YELLOW , !RPIN( YELLOW ) ) ;  
  os.mtdelay (100, tyellow1); 
}

/////////////Task RPUSH    detect push of button and start or stop task TYELLOW
void yellon () {        //called in case of stop
  WPIN(YELLOW, HIGH);            
}
/////
void rpush1 () {              
  os.mtpin (RBUTTON, LOW, rpush2);   //waiting for pushbutton is pressed
}
void rpush2 () {                
  if (os.is_stop(TYELLOW) ) 
    os.start (TYELLOW, tyellow1);
  else os.stop (TYELLOW, yellon);
  os.mtcoop (rpush1);
}

///////////////Task TBLUE     symmetric flashing 
void tblue1 () {
  os.mtsema (GPSEMA, tblue2 );     //use semaphore
}
void tblue2 () {
  os.signal (GPSEMA);           //restore semaphore
  WPIN(BLUE , !RPIN(BLUE) ) ;  
  os.mtdelay (700, tblue1); 
}

///////Task LPUSH   detect push of button and aktivate/deactivate Task TBLUE by semaphore
void lpush1 () {               
  os.mtpin (LBUTTON, LOW, lpush2);   //wait for button is pressed
}
void lpush2 () {                  
  if (os.issema(GPSEMA )) {
    os.clearsema(GPSEMA);         //steal semaphore (deactivate)
    WPIN(BLUE, HIGH);    
  }
  else os.signal (GPSEMA );      //give back semaphore (activate)
  os.mtcoop (lpush1);        
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits    
  os.start (TBLUE, tblue1);
  os.start (TYELLOW, tyellow1);
  os.signal (GPSEMA);
  os.start (LPUSH, lpush1);
  os.start (RPUSH, rpush1);    
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}
#endif    