#ifdef ELEM5
//A shorttime flash of LED BLUE is triggered by pushbutton and followed by a longtime flash

Tnum bl (0,0);       //Tnum object saves flash duration and function pointer to continue task LPUSH

//Subtask subblue is called (twice) by task LPUSH only, that's local use
void subblue1 () {      //single flash of LED BLUE 
  WPIN(BLUE, HIGH ) ;  
  os.mtdelay (bl.OA, subblue2); 
}
void subblue2 () {
  WPIN(BLUE, LOW ) ;  
  os.mtdelay (500, (void(*)())bl.OB );    //cast to function pointer type void(*)()
}

/////////////////Task LPUSH    
void lpush1 () {               
  os.mtpin (LBUTTON, LOW, lpush2);   //wait for pushbutton is pressed
}
void lpush2 () {   
  bl.OA = 800;
  bl.OB = (long) lpush3;      //save function pointer   
  subblue1 ();                //shorttime flash
}
void lpush3 () {   
  bl.OA = 1500;
  bl.OB = (long) lpush1;      //save function pointer   
  subblue1 ();                //longtime flash
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits   
  os.start (LPUSH, lpush1);             
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}

#endif   