#ifdef ELEM6

//Single flash of LED BLUE can be triggered by LBUTTON and by RBUTTON, solution by subtask 

Tnum ht (0,0);   //Tnum object saves flash duration and function pointer to continue task LPUSH or RPUSH

//Subtask subblue is called by two tasks (RPUSH and LPUSH). That's global use. 
//Mutual exclusion by semaphore is needed

void subblue1 () {          //single flash of LED BLUE 
  WPIN(BLUE , HIGH ) ;  
  os.mtdelay (ht.OA, subblue2); 
}
void subblue2 () {
  WPIN(BLUE , LOW ) ;  
  os.mtdelay (500, subblue3); 
}
void subblue3 () {
  os.signal (GPSEMA);              //end of exclusion 
  os.mtcoop ( (void(*)())ht.OB );     //cast to function pointer type void(*)()
}

/////////////Task LPUSH    
void lpush1 () {               
  os.mtpin (LBUTTON, LOW, lpush2);   //waiting for pushbutton is pressed
}
void lpush2 () {    
  os.mtsema (GPSEMA, lpush3);        //if applicable, wait for end of exclusion 
}
void lpush3 () {
  ht.OA = 800;
  ht.OB = (long) lpush1;          //save function pointer 
  subblue1 ();                    //call subtask, continue by calling lpush1
}

/////////////////Task RPUSH    
void rpush1 () {               
  os.mtpin (RBUTTON, LOW, rpush2);   //waiting for pushbutton is pressed
}
void rpush2 () {    
  os.mtsema (GPSEMA, rpush3);        //if applicable, wait for end of exclusion
}
void rpush3 () {
  ht.OA = 3000;
  ht.OB = (long) rpush1;     //save function pointer 
  subblue1 ();               //call subtask, continue by calling rpush1  
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits   
  os.signal (GPSEMA);    //init excl sema   
  os.start (LPUSH, lpush1);
  os.start (RPUSH, rpush1);        
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}
#endif     