#ifdef ELEM8

//Three tasks want to signale a push of LBUTTON by LED flash. Only the flash 
//of one task is allowed at the same time. Therefore mutual exclusion is needed.
//Solution: The pin event of LBUTTON is transformed to sema event and each 
//task is waiting for. Fair alloction is done by builtin queue for tasks, 
//which are waiting for semaphore.

//////////////////Task TYELLOW    single flash triggered by semaphore
void tyellow1 () {
  WPIN(YELLOW, LOW) ;  
  os.mtsema (GPSEMA, tyellow2 );
}
void tyellow2 () {
  WPIN(YELLOW, HIGH);  
  os.mtdelay (100, tyellow1); 
}

//////////////////Task TGREEN     dto.
void tgreen1 () {
  WPIN(GREEN, LOW) ;  
  os.mtsema (GPSEMA, tgreen2 );
}
void tgreen2 () {
  WPIN(GREEN, HIGH);  
  os.mtdelay (100, tgreen1); 
}

////////////////Task TBLUE        dto.
void tblue1 () {
  WPIN(BLUE, LOW) ;  
  os.mtsema (GPSEMA, tblue2 );
}
void tblue2 () {
  WPIN(BLUE, HIGH);  
  os.mtdelay (100, tblue1); 
}

////////Task LPUSH     detect push of button and transform pin event to semaphore event
void lpush1 () {                
  os.mtpin (LBUTTON, LOW, lpush2);  //wait for pushbutton is pressed
}
void lpush2 () {          
  os.signal (GPSEMA);
  os.mtcoop (lpush1);        
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits   
  os.start (LPUSH, lpush1);
  os.start (TBLUE, tblue1);
  os.start (TYELLOW, tyellow1);
  os.start (TGREEN, tgreen1);
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}
#endif    
