/*  Copyright 2023 Dieter Holzhäuser  E-Mail: dieter.holzhauser@gmail.com
  
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published serbuf
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//////////////mtos elements
//Note the following short forms:   
//  WPIN  ~  digitalWrite       RPIN  ~  digitalRead
//  PR    ~  Serial.print       PRln  ~  Serial.println
//  OA    ~  nb[0]              OB    ~  nb[1]       (class Tnum data) 

#include <mtos.h>

///////////////Decomment the desired ELEM definition, only one allowed!!

//#define ELEM1   //Basics

//#define ELEM2   //Inter task operation by global flag

//#define ELEM3   //Inter task operation by semaphore and stop/start

//#define ELEM4   //Finite loop

//#define ELEM5     //Subtask, local use

//#define ELEM6   //Subtask, global use needs mutual exclusion

//#define ELEM7   //Like ELEM6, but use of finite task

//#define ELEM8   //Mutual exclusion and fair allocation

//#define ELEM9   //Problem like ELEM8, but accesses without restriction

//#define ELEM10  //Timeout 

//#define ELEM11   //Simple system monitoring by os.idle (corresponds to reverse CPU load)

#define ELEM12  //Calculation task without events, but with explicit cooperation


////////////////Hardware
//      LED      Output pin
#define YELLOW   10
#define BLUE     11
#define GREEN    12
//LED_BUILTIN    13 
//               Input Pin
#define LBUTTON  17    //-> A3 
#define RBUTTON  18    //-> A4

///////////Task Definitions  ( 0 to 18)
#define TYELLOW        0  
#define TBLUE          1
#define TGREEN         2
#define LPUSH          3
#define RPUSH          4
#define GPCYCLE        5       //General purpose task

/////////////Semaphore Definitions ( 0 to 18 ) 
#define GPSEMA         0       //General purpose semaphore

///////
void setup () {  
  pinMode  (YELLOW, OUTPUT);  
  pinMode  (BLUE, OUTPUT);  
  pinMode  (GREEN, OUTPUT); 
  pinMode  (LED_BUILTIN, OUTPUT); 
  pinMode  (LBUTTON, INPUT_PULLUP);   
  pinMode  (RBUTTON, INPUT_PULLUP); 
  Serial.begin (38400);       
  os.initmt();                         //init multitasking kernel  
  os.start (GPCYCLE, gpcycle1);
  os.runner ();                        //endless                                  
}
//avoid loop()  

