/*  Copyright 2023 Dieter Holzhäuser  E-Mail: dieter.holzhauser@gmail.com
  
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published serbuf
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//Sketch for fun by testing reaction time, by playing music and 
//by calclating prime numbers, all at the same time

#include <mtos.h>
///////////Hardware Definitions
//      LED      Output pin
#define BLUE     11
//LED_BUILTIN    13 
//Speaker         9 (D9)  

//               Input Pin
#define RBUTTON  18    //-> A4

///////////Task Definitions  ( 0 to 18)
#define GPCYCLE    0
#define REAC       1  
#define PLAY       2
#define PRIME      3

/////////////Semaphore Definitions ( 0 to 18 ) 

void setup () {  
  pinMode  (BLUE, OUTPUT);  
  pinMode  (LED_BUILTIN, OUTPUT); 
  pinMode  (RBUTTON, INPUT_PULLUP); 
  os.initmt();            //init multitasking kernel  
  Serial.begin (38400);                      
  sr.initserinp();        //init serial user input              
  os.start (GPCYCLE, gpcycle1);
  os.start (REAC, reac1);
  os.runner ();                                             
}
//avoid loop() 



