//User inputs and command functions by completion of library task SUI
//Task GPCYCLE        general purpose cycle

void gpcycle1 () {       //to add own and other inits    
  PR ("Have fun! ");  
  mprint (LF_menu);
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}

//////Completion of library task SUI 
const char idle [] PROGMEM =   "idle   --  CPU";
const char radetz [] PROGMEM = "radetz --  Song";
const char aura [] PROGMEM =   "aura   --  Song";
const char santa [] PROGMEM =  "santa  --  Song";
const char stop [] PROGMEM =   "stop   --  Stop song";
const char prime [] PROGMEM =  "prime  --  Start/Stop";
const char primrst [] PROGMEM ="prime< --  Restart";
struct cmdstruct cmds [] =  { {idle,  cmd_idle},
                              {radetz, cmd_ra},
                              {aura, cmd_au},
                              {santa, cmd_sa}, 
                              {stop,  cmd_stop}, 
                              {prime, cmd_prime}, 
                              {primrst, cmd_prime_rst}, 
                            };
char maxcmds = sizeof (cmds) / sizeof (cmdstruct) ;

void cmd_idle() {
  PRln (os.idle);  
  os.mtcoop (sui_clear);
}

void cmd_prime_rst () {
  os.stop (PRIME,0);
  PRln();
  pri.testnum = PRIMEBEGIN;     //must be an odd number!!!!  
  pri.columns = 0;   
  os.start (PRIME, prime1);
  os.mtcoop (sui_clear);
}

void cmd_prime () {
  if (os.is_stop(PRIME) ) {
    os.start (PRIME, prime1);
    PRln ("on");
  }
  else {
    os.stop (PRIME, 0);
    PRln ("off"); 
  }
  os.mtcoop (sui_clear);
}

void cmd_ra () {
  sg.playstop (); 
  sg.psong = radetzky;
  cd_all ();
}
void cmd_au () {
  sg.playstop (); 
  sg.psong = auralee;
  cd_all ();
}
void cmd_sa () {
  sg.playstop (); 
  sg.psong = santalucia;
  cd_all ();
}
void cd_all () {
  PRln ("on");
  os.mtdelay (1000, cd_start);
}
void cd_start () {
  os.start (PLAY, play1);  
  os.mtcoop (sui_clear);   
}

void cmd_stop () {
  sg.playstop (); 
  PRln ();
  os.mtcoop (sui_clear);   
}
//////////end of completion  
