#ifdef SER2
//Three kinds to set frequency data of flashing LED by user, 
//EEMEM storage

Tnum ye (100,0); 
Tnum bl (50, 0 );    //50 ~ 0.50 
Tnum gr (500,1000);

////////Task TELLOW      symmetric flashing of LED YELLOW
void tyellow1 () {        
    WPIN(YELLOW, !RPIN(YELLOW) ); 
    os.mtdelay (ye.OA, tyellow1);   
}

///////////Task TBLUE    symmetric flashing of LED BLUE
void tblue1 () {        
  WPIN (BLUE, !RPIN(BLUE) ); 
  os.mtdelay ( bl.OA * 10 , tblue1);   //e.g.  50 * 10 = 500 ms = 0.5 s
}

/////Task TGREEN    asymmetric flashing of LED GREEN
void tgreen1 () {
  WPIN(GREEN, HIGH); 
  os.mtdelay (gr.OA, tgreen2 );
}
void tgreen2 () {
  WPIN(GREEN, LOW); 
  os.mtdelay (gr.OB, tgreen1);
}

//see SER1
const char yellow [] PROGMEM = "yello i-  on/off ms";
const char blue   [] PROGMEM = "blue   f-  on/off x.xx s";
const char green  [] PROGMEM = "green  ii  on ms /off ms";
struct cmdstruct cmds [] = { {yellow, cmd_yellow},
                             {blue, cmd_blue},  
                             {green, cmd_green}  };
char maxcmds = sizeof (cmds) / sizeof (cmdstruct) ;

void cmd_yellow() {
  switch (sr.inum) {
    case 0: ye.outp ( "$g$i ms$n");   //get task data
            break;
   default: if (IA <= 0) 
                mprint (range_error);  
            else {
                ye.OA = IA;           //set task data
                ye.outp ( "$s$i ms$n");
                os.stop (TYELLOW,0);          //Timer should be killed
                os.start (TYELLOW, tyellow1);     
            }
  }
  os.mtcoop (sui_clear);
}

void cmd_blue() {
  switch (sr.inum) {
      case 0: bl.outp ( "$g$f s$n");   //get task data
              break;                           
     default: if (IA < 5 || IA > 500)    // ~  0.05 to 5 s
                mprint (range_error);  
              else {
                bl.OA = IA;   
                bl.outp ( "$s$f s$n");
              }
  }
  os.mtcoop (sui_clear);
} 

void cmd_green() {
  switch (sr.inum) {
      case 0: gr.outp ( "$g$i ms $I ms$n");
              break;
      case 1: mprint (num_missed);
              break;
     default: if ( IA < 10  || IA > 3000 || IB < 10  || IB > 3000  )
                mprint (range_error);  
              else {
                gr.OA = IA;
                gr.OB = IB;
                gr.outp ( "$s$i ms $I ms$n");
                eewrite ( gr.nb, sizeof(gr.nb), 0, sui_clear );  //store gre data to EEMEN
                return;    //subtask, return must follow !!                                     
              }                                    
  }           
  os.mtcoop (sui_clear);
} 

////////task GPCYCLE    general purpose 
void gpcycle1 () {      //to add own and other inits  
  PR ("SER2 Hello, ");
  mprint (LF_menu);
  os.start (TYELLOW, tyellow1);
  os.start (TBLUE, tblue1);
  os.start (TGREEN, tgreen1); 
  eeread (0 , sizeof(gr.nb) , gr.nb );   //restore gre data from EEMEM
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //general purpose cycle  
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);
} 

#endif
