#ifdef SER3

//System monitoring 

Tnum idl (NONB,0);  //idle session data     

/////see SER1
const char idle [] PROGMEM =    "idle  --  CPU";
const char runti   [] PROGMEM = "runti --  system run time";
const char clock   [] PROGMEM = "clock t-  get/set clock";
struct cmdstruct cmds [] = { { idle, cmd_idle},
                             {runti, cmd_runti}, 
                             {clock, cmd_clock},                        
                          };
char maxcmds = sizeof (cmds) / sizeof (cmdstruct) ;

void cmd_idle() {      //Can find minimal idle (~ max cpu load) during a session         
    if (idl.OA == NONB) {        //begin of session 
      idl.OA = os.idle;          //actual idle
      idl.OB = os.bclock;        //actual time
      idl.outp ("$i begin $T$n");
      os.mtdelay (1100, cmd_idle1);  //influence of idl.outp should be avoided
      return;                       
    }
    else {                          //end of session 
      idl.outp ( "$i $T end ");     //result
      idl.OA = os.bclock;
      idl.outp ( "$t$n");  
      idl.OA = NONB;                //stop
    } 
    os.mtcoop (sui_clear); 
}
void cmd_idle1() {                  //real start of idle session
  idl.OA = 10000;                   //see gpcycle2
  os.mtcoop (sui_clear);
}

void cmd_runti() {                    //get program running time 
  long ti = os.get_clock();
  if (ti < 0 ) ti = ti + 2147483648;  //clock overflow -> clock negative
  PR ( (float) ti / 3600000 );
  PRln (" h");
  os.mtcoop (sui_clear);
}

void cmd_clock() {        //adjust base clock manually or 
  switch (sr.inum) {      //let synchronize base clock by PC cronjob,
    case 0: PR (">> ");   //see following description
            prtime (os.bclock);  
            break;
    default: if ( trtime (IA) != SECDAY ) {
               os.bclock = trtime (IA);
             }
  }
  PRln ();
  os.mtcoop (sui_clear);
}
/*
Arduino Nano can operate standalone, preferably connected to Raspberry Pi.
In this way Nano is accessible via LAN and Internet.
A 100nF capacitor between Nano RST and VCC prevents resets, when  
Raspis serial interface is opened.
Python Script mtcomm.py on Raspi provides line-oriented serial 
runtime communication to the Nano, like Arduino Serial Monitor.
Additionally Raspi cronjob cronclock.py can send time 
information every minute to synchronize Nanos base clock.
*/

////////Task GPCYCLE    general purpose
void gpcycle1 () {      //to add own and other inits  
  PR ("SER3 Hello, ");
  mprint (LF_menu);
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {     //general purpose cycle  
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  if (idl.OA != NONB) {    ////idle session         
    if ( os.idle < idl.OA ) {
      idl.OA = os.idle;        
      idl.OB = os.bclock;
    }
  }
  os.mtdelay (1000, gpcycle2);
} 

#endif 
