#ifdef SER4
//Multi-Channel Timer on LED YELLOW, base clock

#define  TIMER  TYELLOW     //Rename task TYELLOW 

class Tinum : public Tnum {
  public:
  Tinum  (long nb0, long nb1): Tnum (nb0, nb1)  {
  }
  bool dotinum () {
    if (os.get_taskstate (TIMER) == WAITING_S ) 
      PRln ("clock must be set");
    else
    switch (sr.inum ) {
      case 0: 
        outp ("$g$t $T$n");         //get range
        break;
      case 1: 
        mprint (num_missed);   
        break;
      default:  
        if (IA != NONB )  {
             IA = trtime(IA); 
             if (IA != SECDAY ) 
               OA = IA;
             else {
               mprint (range_error);
               break;
             }
        }
        if (IB != NONB )  {
             IB = trtime(IB); 
             if (IB != SECDAY ) 
               OB =  IB;
             else {
               mprint (range_error);
               break;
             } 
        }
        outp ("$s$t $T$n");
        return true;
    }
    return false;
  }
};

//time channels "from","to"
Tinum ti1  (0,0);     
Tinum ti2  (0,0);     
Tinum ti3  (0,0); 

/////////Task TIMER
void timer1() {
  os.mtsema (GPSEMA, timer2);      //wait for base clock is set
}                         
void timer2() {
  if (os.timeinrange (ti1.OA,ti1.OB)  ||  
        os.timeinrange (ti2.OA,ti2.OB)  ||  
            os.timeinrange (ti3.OA,ti3.OB) ) 
    WPIN (YELLOW,HIGH);
  else WPIN (YELLOW,LOW);
  os.mtdelay (1000,timer2);
} 
////////see SER1
const char cti1   [] PROGMEM = "ti1   tt from to";
const char cti2   [] PROGMEM = "ti2   tt from to";
const char cti3   [] PROGMEM = "ti3   tt from to";
const char clock [] PROGMEM = "clock t- set/get clock";
struct cmdstruct cmds [] = { {cti1, cmd_ti1},
                             {cti2, cmd_ti2},
                             {cti3, cmd_ti3},
                             {clock, cmd_clock}   };                      
char maxcmds = sizeof (cmds) / sizeof (cmdstruct) ;

void cmd_ti1 () {
  if (ti1.dotinum())
    eewrite (ti1.nb, sizeof(ti1.nb) ,8 , sui_clear);
  else os.mtcoop (sui_clear);
}
void cmd_ti2 () {
  if (ti2.dotinum() )
    eewrite (ti2.nb, sizeof(ti2.nb) ,16 , sui_clear);  
  else os.mtcoop (sui_clear);
}
void cmd_ti3 () {
  if (ti3.dotinum())
    eewrite (ti3.nb, sizeof(ti3.nb) ,24 , sui_clear);  
  else os.mtcoop (sui_clear);
}

void cmd_clock() {     //adjust base clock manually or 
  switch (sr.inum) {   //let synchronize base clock by PC cronjob, see SER3
    case 0: PR (">> "); 
            prtime (os.bclock);  
            break;
    default: if ( trtime (IA) != SECDAY ) {
               os.bclock = trtime (IA);
               os.signal (GPSEMA);     //signale: base clock is set
             }
  }
  PRln ();
  os.mtcoop (sui_clear);
}

////////Task GPCYCLE    general purpose  
void gpcycle1 () {      //to add own and other inits  
  PR ("SER4 Hello, ");
  mprint (LF_menu);
  os.start (TIMER,timer1);
  eeread (8, 8, ti1.nb);
  eeread (16, 8, ti2.nb);
  eeread (24, 8, ti3.nb);
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {     //general purpose cycle  
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life
  os.mtdelay (1000, gpcycle2);
} 

#endif 
